//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit4.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CTLHOOK"
#pragma link "DROPDST"
#pragma resource "*.dfm"
TForm4 *Form4;
extern TIniFile *ini; // FCDUtil.cpp
//---------------------------------------------------------------------------
__fastcall TForm4::TForm4(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm4::set_list(FCD *in)
{
    int i;
    char *dir;
    TListItem* item;

    fcd = in;

    dir = get_directory(fcd->cdi.ti[0].filename);
    input_select_dialog->InitialDir = dir;
    free(dir);

    track_view->Items->Clear();

    track_view->Items->BeginUpdate();
    for(i=0;i<fcd->cdi.num_of_track;i++){
        item = track_view->Items->Add();
        set_list_line(item);
    }
    track_view->Items->EndUpdate();

    output_file_edit->Text = fcd->path;
}
//---------------------------------------------------------------------------
void __fastcall TForm4::moveClick(TObject *Sender)
{
    int i,track;
    bool down;

    if(track_view->Selected == NULL){
        return;
    }

    track = track_view->Selected->Index;

    if(((TButton *)Sender)->Name.AnsiCompare("down") == 0){
        down = true;
        track += 1;
    }else{
        down = false;
    }

    if(!move_track(fcd, track, 0)){
        return;
    }

    for(i=track-1;i<fcd->cdi.num_of_track;i++){
        set_list_line(track_view->Items->Item[i]);
    }

    if(!down){
        track -= 1;
    }
    track_view->Selected = NULL;
    track_view->Selected = track_view->Items->Item[track];

    track_view->Selected->MakeVisible(false);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::set_list_line(TListItem *item)
{
    int i;
    char b[256];

    i = item->Index;

    item->Caption = read_filename(fcd->cdi.ti[i].filename);

    item->SubItems->Clear();

    switch(fcd->cdi.ti[i].type){
    case FCD_TYPE_ISO:
        item->SubItems->Add("ISO");
        break;
    case FCD_TYPE_RAW:
        item->SubItems->Add("RAW");
        break;
    case FCD_TYPE_DA:
        item->SubItems->Add("DA");
        break;
    default:
        item->SubItems->Add(" ");
    }

    sprintf(b, "%6d", fcd->cdi.ti[i].start);
    item->SubItems->Add(b);

    sprintf(b, "%6d", fcd->cdi.ti[i].start + fcd->cdi.ti[i].num_of_block);
    item->SubItems->Add(b);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::delClick(TObject *Sender)
{
    int i,top;
    int dc; /* delete count */

    if(track_view->Selected == NULL){
        return;
    }

    top = track_view->Selected->Index;

    dc = 0;
    for(i=top;i<track_view->Items->Count;i++){
        if(track_view->Items->Item[i]->Selected){
            if(fcd2fcd && fcd->cdi.ti[i-dc].type != FCD_TYPE_DA){
                cant_delete_data_track();
                continue;
            }
            del_track(fcd, i-dc);
            dc += 1;
        }
    }

    track_view->Selected = NULL;
    track_view->Items->BeginUpdate();
    for(i=0;i<dc;i++){
        track_view->Items->Delete(track_view->Items->Count-1);
    }

    for(i=top;i<track_view->Items->Count;i++){
        set_list_line(track_view->Items->Item[i]);
    }
    track_view->Items->EndUpdate();

    FormShow(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::addClick(TObject *Sender)
{
    int i;
    char *w;
    TListItem *item;

    track_view->Items->BeginUpdate();
    if(input_select_dialog->Execute()){
        track_view->Selected = NULL;
        for(i=0;i<input_select_dialog->Files->Count;i++){
            w = input_select_dialog->Files->Strings[i].c_str();
            if(fcd2fcd && !check_sfx(w, ".wav") && !check_sfx(w, ".mp3")){
                cant_add_data_track();
                continue;
            }
            if(add_track(fcd, w)){
                item = track_view->Items->Add();
                set_list_line(item);
                item->MakeVisible(false);
            }else{
                add_track_error(w);
                break;
            }
        }
    }
    track_view->Items->EndUpdate();

    input_select_dialog->FileName = "";
    input_select_dialog->InitialDir = "";

    if(track_view->Items->Count < TRACK_MAX){
        add->Enabled = true;
    }else{
        add->Enabled = false;
    }
    FormShow(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::executeClick(TObject *Sender)
{
    fcd->path = (char *)malloc(strlen(output_file_edit->Text.c_str()) + 1);
    strcpy(fcd->path, output_file_edit->Text.c_str());
    
    ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TForm4::WMSysCommand(TWMSysCommand& Msg)
{
    if ( (Msg.CmdType & 0xfff0) == SC_MINIMIZE ){
        Application->Minimize();
    }else{
        TForm::Dispatch(&Msg);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm4::FormShow(TObject *Sender)
{
    if(track_view->Items->Count){
        execute->Enabled = true;
    }else{
        execute->Enabled = false;
    }

    if(track_view->Items->Count < 2){
        sort->Enabled = false;
    }else{
        sort->Enabled = true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm4::DropDst1FileDrop(TObject *Sender, TStrings *Files,
      int X, int Y)
{
    int i;
    char *w;
    TListItem *item;

    for(i=0;i<Files->Count;i++){
        w = Files->Strings[i].c_str();
        if(fcd2fcd && !check_sfx(w, ".wav") && !check_sfx(w, ".mp3")){
            cant_add_data_track();
            continue;
        }
        if(add_track(fcd, w)){
            item = track_view->Items->Add();
            set_list_line(item);
        }else{
            add_track_error(w);
        }
    }
    FormShow(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::sortClick(TObject *Sender)
{
    int i;

    track_view->Selected = NULL;

    if(!sort_track_by_name(fcd)){
        return;
    }

    track_view->Items->BeginUpdate();
    for(i=0;i<track_view->Items->Count;i++){
        set_list_line(track_view->Items->Item[i]);
    }
    track_view->Items->EndUpdate();
}
//---------------------------------------------------------------------------
void __fastcall TForm4::track_viewChange(TObject *Sender, TListItem *Item,
      TItemChange Change)
{
    if(Change == ctState){
        if(track_view->SelCount == 0){
            up->Enabled = false;
            down->Enabled = false;
            del->Enabled = false;
        }else if(track_view->Selected->Index == 0){
            up->Enabled = false;
            down->Enabled = true;
            del->Enabled = true;
        }else if(track_view->Selected->Index == track_view->Items->Count-1){
            up->Enabled = true;
            down->Enabled = false;
            del->Enabled = true;
        }else{
            up->Enabled = true;
            down->Enabled = true;
            del->Enabled = true;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm4::FormCreate(TObject *Sender)
{
    track_view->Columns->Items[0]->Width = track_view->Width * 200 / 425;
    track_view->Columns->Items[1]->Width = track_view->Width * 40 / 425;
    track_view->Columns->Items[2]->Width = track_view->Width * 80 / 425;
    track_view->Columns->Items[3]->Width = track_view->Width * 80 / 425;

    min_width = Width;
    min_height = Height;

    old_width = Width;
    old_height = Height;

    set_size_position();

    set_language();
}
//---------------------------------------------------------------------------
void __fastcall TForm4::FormResize(TObject *Sender)
{
    static const int button_right_offset = 19;

    up->Left = Width - up->Width - button_right_offset;
    down->Left = up->Left;
    del->Left = up->Left;
    add->Left = up->Left;
    sort->Left = up->Left;
    execute->Left = up->Left;
    change_output->Left = up->Left;

    output_file_edit->Width += Width - old_width;

    track_view->Height += Height - old_height;
    track_view->Width += Width - old_width;
    track_view->Columns->Items[0]->Width += Width - old_width;

    old_width = Width;
    old_height = Height;
}
//---------------------------------------------------------------------------
void __fastcall TForm4::WMGetMinMaxInfo(TMessage& Message)
{
    MINMAXINFO *Info = (LPMINMAXINFO)Message.LParam;

    Info->ptMinTrackSize.x = min_width;
    Info->ptMinTrackSize.y = min_height;
}
//---------------------------------------------------------------------------
void __fastcall TForm4::change_outputClick(TObject *Sender)
{
    char *dir;

    dir = get_directory(output_file_edit->Text.c_str());
    output_select_dialog->InitialDir = dir;
    free(dir);

    output_select_dialog->FileName = output_file_edit->Text;

    if(output_select_dialog->Execute()){
        output_file_edit->Text = output_select_dialog->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm4::set_size_position()
{
    int n;

    n = ini->ReadInteger("TRACK_SETUP", "WIDTH", -1);
    if( (n >= min_width) && (n < Screen->Width) ){
        Width = n;
    }

    n = ini->ReadInteger("TRACK_SETUP", "HEIGHT", -1);
    if( (n >= min_height) && (n < Screen->Height) ){
        Height = n;
    }

    n = ini->ReadInteger("TRACK_SETUP", "LEFT", -1);
    if( (n >= 0) && (n < Screen->Width) ){
        Left = n;
    }

    n = ini->ReadInteger("TRACK_SETUP", "TOP", -1);
    if( (n >= 0) && (n < Screen->Height) ){
        Top = n;
    }


    if(ini->ReadBool("TRACK_SETUP", "MAXIMIZE", false)){
        WindowState = wsMaximized;
    }

}
//---------------------------------------------------------------------------
void __fastcall TForm4::save_size_position()
{
    if(WindowState == wsMaximized){
        ini->WriteBool("TRACK_SETUP", "MAXIMIZE", true);
        return;
    }

    ini->WriteBool("TRACK_SETUP", "MAXIMIZE", false);

    ini->WriteString("TRACK_SETUP", "WIDTH", Width);
    ini->WriteString("TRACK_SETUP", "HEIGHT", Height);
    ini->WriteString("TRACK_SETUP", "LEFT", Left);
    ini->WriteString("TRACK_SETUP", "TOP", Top);

}
//---------------------------------------------------------------------------
void __fastcall TForm4::FormClose(TObject *Sender, TCloseAction &Action)
{
    save_size_position();
}
//---------------------------------------------------------------------------
void __fastcall TForm4::set_language()
{
    LANGID id;

    id = GetUserDefaultLangID();

    if(id == 0x0411){
        language = LANGUAGE_TYPE_JAPANESE;
    }else{
        Font->Charset = ANSI_CHARSET;
        Font->Name = "Arial";

        Caption = "Track Edit";
        Label1->Caption = "Output :  ";
        change_output->Caption = "Refer";
        track_view->Columns->Items[0]->Caption = "Filename";
        track_view->Columns->Items[1]->Caption = "Type";
        track_view->Columns->Items[2]->Caption = "Start";
        track_view->Columns->Items[3]->Caption = "End";

        up->Caption = "UP";
        down->Caption = "DOWN";
        add->Caption = "ADD";
        del->Caption = "DEL";
        sort->Caption = "SORT";
        execute->Caption = "EXEC";

        input_select_dialog->Filter = "All file (*.*)|*.*|Track image (*.ISO, *.XA, *.IMG)|*.ISO;*.XA;*.IMG|Sound file (*.WAV, *.MP3)|*.WAV;*.MP3";
        output_select_dialog->Filter = "FCD File (*.FCD)|*.FCD|All file (*.*)|*.*";
        language = LANGUAGE_TYPE_ENGLISH;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm4::cant_delete_data_track()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        Application->MessageBox(" FCD t@C̃gbNҏWɂ́Af[^gbN̍폜͂ł܂", "s", MB_OK|MB_ICONERROR);
    }else{
        Application->MessageBox("In the FCD track edit mode, can't delete DATA track", "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm4::cant_add_data_track()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        Application->MessageBox(" FCD t@C̃gbNҏWɂ́Af[^gbN̒ǉ͂ł܂", "s", MB_OK|MB_ICONERROR);
    }else{
        Application->MessageBox("In the FCD track edit mode, can't add DATA track", "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm4::add_track_error(char *path)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s gbNXgɒǉł܂ł", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in the addition to track list of %s", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------


